/* 
================================================================================ 
AMX Mod Plugin 
http://amxmod.net 
-------------------------------------------------------------------------------- 
Name    : Graves 
Author : Freecode <Freecode@hotmail.com> 
-------------------------------------------------------------------------------- 
Graves v 2.0 
    Created by Freecode 

    Graves 
    ================ 
    On death a grave will be placed where you died. 

    USAGE 
    ===== 
        
    amx_grave <1 = ON || 0 = OFF> 
    amx_graveyard <1 = ON || 0 = OFF> 
        
    Releases: 
    ======== 
    2003-10-27    version 1.0: 
                  First version 
                  
    2003-10-27    version 2.0: 
                  Fixed graves. Now stay untill the end of round.
                  Added amx_graveyard <1/0> 
                  
    TO DO 
    ===== 
    -Fix Models

-------------------------------------------------------------------------------- 
Installation : 
- Extract file grave.amx to directory addons/amx/plugins 
- Open addons/amx/plugins/plugins.ini 
- Add a line containing : grave.amx
- Place the graves[id] folder into models directory.
ex.- cstrike/models/graves[id]/ 
==================================================================== 
*/ 
#include <amxmodx> 
#include <engine>
#include <amxmisc> 

/********GLOBAL*VARIABLES*******/
new graveyard = 0
new graves[32]
new nGrave = 0
/********END*GLOBAL*VARIABLES*******/

/********GRAVE*CONTROL*******/
public grave(id,level,cid)
{ 
	if (!cmd_access(id,level,cid,1))
		return PLUGIN_HANDLED 
		
	new arg[32]
	read_argv(1,arg,31)
	if(arg[0] == '1')
	{
		nGrave = 1
		graveyard = 0
		console_print(id,"[AMX] Graves are ON.")
	}
	else if(arg[0] == '0')
	{
		nGrave = 0
		console_print(id,"[AMX] Graves are OFF.")
	}
		
	return PLUGIN_HANDLED
}
/********END*GRAVE*CONTROL*******/

/********GRAVEYARD*CONTROL*******/
public graveyardc(id,level,cid)
{ 
	if (!cmd_access(id,level,cid,1))
		return PLUGIN_HANDLED 
		
	new arg1[32]
	read_argv(1,arg1,31)
	if(arg1[0] == '1')
	{
		nGrave = 1
		graveyard = 1
		console_print(id,"[AMX]Graveyard is ON.")
	}
	else if(arg1[0] == '0')
	{
		graveyard = 0
		console_print(id,"[AMX]Graveyard is OFF.")
	}
	
	return PLUGIN_HANDLED
}
/********END*GRAVEYARD*CONTROL*******/

/********GRAVECODE*******/
public make_gave(id) 
{ 
	if(nGrave == 1 || graveyard == 1) 
	{ 
		new victim = read_data(2) 
		new origin[3]
		new Float:fOrigin[3]
		get_user_origin(victim,origin) 
		
		fOrigin[0]=float(origin[0])
		fOrigin[1]=float(origin[1])
		fOrigin[2]=float(origin[2])
		
		graves[id] = create_entity("info_target")
		entity_set_string(graves[id], EV_SZ_classname, "grave")
		if(get_user_team(victim) == 1)
			entity_set_model(graves[id],"models/graves/t.mdl")
		else
			entity_set_model(graves[id],"models/graves/ct.mdl")
		entity_set_origin(graves[id], fOrigin)
		entity_set_int(graves[id], EV_INT_solid, 2) 
		entity_set_int(graves[id], EV_INT_movetype, 4)
		entity_set_edict(graves[id], EV_ENT_owner, victim) 
	} 
	return PLUGIN_HANDLED 
}
/********END*GRAVECODE*******/

public NewRound(id) 
{ 
	if(nGrave == 1 && graveyard != 1) 
	{ 	
		new gGrave[32] 
		new iGrave = find_ent_by_tname(-1, "grave") 
		while(iGrave > 0) 
		{ 
			entity_get_string(iGrave, EV_SZ_classname, gGrave, 31) 
			if(equal(gGrave, "grave") )   
				remove_entity(iGrave) 

			iGrave = find_ent_by_tname(-1, "grave") 
		} 

	}
} 

public plugin_precache() 
{ 
	precache_model("models/graves/ct.mdl") 
	precache_model("models/graves/t.mdl") 
} 

public plugin_init() 
{ 
	register_plugin("Graves","2.0","Freecode") 
	register_event("DeathMsg","make_gave","a")
	register_event("ResetHUD","NewRound","bc")
	register_clcmd("amx_grave","grave",ADMIN_BAN,"1/0")
	register_clcmd("amx_graveyard","graveyardc",ADMIN_BAN,"1/0")
} 