#include <amxmodx>
#include <fakemeta>

#define PLUGIN "Paintball Mod"
#define VERSION "1.1"
#define AUTHOR "WhooKid"

new onoff,bammo,money,strip,monem,protc;

public plugin_init()
{
	register_plugin(PLUGIN,VERSION,AUTHOR);
	register_forward(FM_GetGameDescription,"fw_gamedesc");
	register_logevent("new_round", 2, "0=World triggered", "1=Round_Start");
	register_event("ResetHUD","player_resethud","b");
	onoff = register_cvar("amx_pbmod","1");
	bammo = register_cvar("amx_pbammo","4");
	money = register_cvar("amx_pbmoney","1");
	strip = register_cvar("amx_pbstrip","1");
	protc = register_cvar("amx_pbspawnprotect","5");
	monem = get_user_msgid("Money");
}

public fw_gamedesc()
{
	if (get_cvar_num("amx_pbmod"))
	{
		forward_return(FMV_STRING,PLUGIN);
		return FMRES_SUPERCEDE;
	}
	return FMRES_IGNORED;
}

public new_round()
{
	if (get_pcvar_num(onoff) && get_pcvar_num(strip))
	{
		new ent;
		while ((ent = engfunc(EngFunc_FindEntityByString,ent,"classname","armoury_entity")) != 0)
			engfunc(EngFunc_RemoveEntity,ent);
	}
}

public player_resethud(id)
{
	if (get_pcvar_num(onoff))
		set_task(0.2,"player_spawn",id);
}

public player_spawn(id)
{
	if (is_user_alive(id))
	{
		set_task(1.0,"player_weapons",id);

		if (get_pcvar_num(strip))
			fm_strip_user_weapons(id);

		if (get_pcvar_num(money))
		{
			set_pdata_int(id,115,0,5);
			message_begin(MSG_ONE,monem,_,id);
			write_long(0);
			write_byte(0);
			message_end();
		}

		if (get_pcvar_num(protc))
		{
			set_pev(id,pev_takedamage,DAMAGE_NO);
			set_task(float(get_pcvar_num(protc)),"player_godmodeoff",id+100);
		}
	}
}

public player_weapons(id)
{
	if (is_user_alive(id))
	{
		new num;
		fm_give_item(id,"weapon_knife");
		fm_give_item(id,"weapon_mp5navy");
		while (num++ < get_pcvar_num(bammo))
			fm_give_item(id,"ammo_9mm");
	}
}

public player_godmodeoff(id)
	set_pev(id-100,pev_takedamage,DAMAGE_AIM);

////////*****************VEN STOCKS START*****************////////
stock fm_strip_user_weapons(index)
{
	new ent = engfunc(EngFunc_CreateNamedEntity,engfunc(EngFunc_AllocString,"player_weaponstrip"));
	if (!pev_valid(ent))
		return 0;
	dllfunc(DLLFunc_Spawn, ent);
	dllfunc(DLLFunc_Use, ent, index);
	engfunc(EngFunc_RemoveEntity, ent);
	return 1;
}

stock fm_give_item(index,const item[])
{
	if (!equal(item, "weapon_", 7) && !equal(item, "ammo_", 5) && !equal(item, "item_", 5) && !equal(item, "tf_weapon_", 10))
		return 0;
	new ent = engfunc(EngFunc_CreateNamedEntity,engfunc(EngFunc_AllocString,item));
	if (!pev_valid(ent))
		return 0;
	new Float:origin[3];
	pev(index, pev_origin, origin);
	set_pev(ent, pev_origin, origin);
	set_pev(ent, pev_spawnflags, pev(ent, pev_spawnflags) | SF_NORESPAWN);
	dllfunc(DLLFunc_Spawn, ent);
	new save = pev(ent, pev_solid);
	dllfunc(DLLFunc_Touch, ent, index);
	if (pev(ent, pev_solid) != save)
		return ent;
	engfunc(EngFunc_RemoveEntity, ent);
	return -1;
}
////////*****************VEN STOCKS END*****************////////
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
